DECLARE
  -- Definir el tipo de registro basado en la estructura de la tabla de ejemplo 'posts'
  TYPE post_record IS RECORD (
    id NUMBER,
    title VARCHAR2(255),
    content VARCHAR2(4000),
    created_at DATE
  );

  -- Definir el tipo de cursor y el cursor para la consulta de la tabla 'posts'
  TYPE post_cursor IS REF CURSOR;
  posts_cur post_cursor;

  -- Definir una variable para almacenar el registro actual
  post_rec post_record;

BEGIN
  -- Abrir el cursor con la consulta SQL para obtener todos los posts ordenados por 'created_at'
  OPEN posts_cur FOR
    SELECT id, title, content, created_at
    FROM posts
    ORDER BY created_at DESC;

  -- Procesar los registros del cursor uno por uno
  LOOP
    -- Obtener el siguiente registro del cursor
    FETCH posts_cur INTO post_rec;

    -- Salir del bucle si no hay más registros
    EXIT WHEN posts_cur%NOTFOUND;

    -- Procesar el registro actual (por ejemplo, imprimirlo en la consola)
    DBMS_OUTPUT.PUT_LINE('Post ID: ' || post_rec.id);
    DBMS_OUTPUT.PUT_LINE('Título: ' || post_rec.title);
    DBMS_OUTPUT.PUT_LINE('Contenido: ' || post_rec.content);
    DBMS_OUTPUT.PUT_LINE('Fecha de creación: ' || TO_CHAR(post_rec.created_at, 'DD/MM/YYYY'));
    DBMS_OUTPUT.PUT_LINE('--------------------------');
  END LOOP;

  -- Cerrar el cursor
  CLOSE posts_cur;
END;
